

' ******************** ****************************************
' Utworzenie nowego katalogu wirtualnego dla tego przykadu.
'
' Ustawienie vName na nazw publikowanego katalogu wirtualnego.
'
' Katalog wirtualny zostanie utworzony pod adresem http://localhost/CLRUnleashed/vName
'
'
' Poprawne przeczniki wiersza polece: -u -q
'   -u  Usunicie katalogu wirtualnego
'   -q  Praca w "cichym" trybie (bez okien dialogowych)
'
' *************************************************************


Option Explicit
dim vPath,vNames,vPaths,scriptPath,vBaseName,objArgs,remove,quiet,I

' Uzyskanie aktualnej cieki do katalogu
vPath = left(Wscript.ScriptFullName,len(Wscript.ScriptFullName ) - len(Wscript.ScriptName))


vNames = Array("TimeService") ' Nazwy katalogw do utworzenia
vPaths = Array(vPath + "") ' cieki katalogw do utworzenia


vBaseName="CLRUnleashed"

remove = False
quiet = False

Set objArgs = WScript.Arguments

For I = 0 To objArgs.Count - 1 
    If InStr(LCase(objArgs(I)), "u") <> 0 Then
        remove = True
    End If
    If InStr(LCase(objArgs(I)), "q") <> 0 Then
        quiet = True
    End If
Next

If remove Then
    'wywoanie w celu usunicia vDir
    DeleteVDir vNames, vBaseName
Else
    'wywoanie w celu utworzenia vDir
    CreateVDir vNames, vPaths, vBaseName
End If



'Poniszy kod pochodzi z mkwebdir.vbs i zosta zmieniony tak, aby utworzy jeden katalog vDir.
Sub CreateVDir(vNames, vPaths, vBaseName)

    Dim vRoot,vBaseDir,vDir,vTempDir,webSite,ipSecurityObj,ipList
    On Error Resume Next

    ' Uzyskanie domylnej witryny lokalnego hosta
    set webSite = GetObject("IIS://localhost/w3svc/1")
    if IsObject(webSite)=False then
        If Not quiet Then
            Display "Odnalezienie domylnej witryny nie byo moliwe. Naley zainstalowa IIS."
        End If
        exit sub
    else
        'display webSite.name
    end if

    ' Uzyskanie katalogu macierzystego
    set vRoot = webSite.GetObject("IIsWebVirtualDir", "Root")
    If (Err <> 0) Then
        If Not quiet Then
            Display "Nie mona odnale katalogu macierzystego dla " & webSite.ADsPath
        End If
        Exit sub
    else
        'display vRoot.name
    End If

    ' Odnalezienie lub utworzenie NetSDK vroot. Jest to macierzysty vroot dla wszystkich przykadw NetSDK.
    ' Fizyczna cieka do http://localhost/CLRUnleashed jest ustawiona na folder ...\Samples\Setup\VirtualDirRoot.
    Err.Number = 0 'Skasowanie bdu
    Set vBaseDir = GetObject(vRoot.ADsPath & "/" & vBaseName)
    if Err.Number <> 0 then
        Err.Number = 0 ' skasowanie bdu
        Set vBaseDir = vRoot.Create("IIsWebVirtualDir",vBaseName)
        vBaseDir.AccessRead = true
        vBaseDir.Accessflags = 529
        vBaseDir.AppCreate False
        vBaseDir.SetInfo

        ' Ta sekcja kodu ogranicza dostp dla wszystkich z wyjtkiem localhosta (127.0.0.1).
        Set ipSecurityObj = vBaseDir.IpSecurity
        ipSecurityObj.GrantByDefault = False
        ipList = ipSecurityObj.IPGrant
        ReDim ipList(UBound(ipList) + 1)
        ipList(UBound(ipList)) = "127.0.0.1"
        ipSecurityObj.IPGrant = ipList
        vBaseDir.IpSecurity = ipSecurityObj
        vBaseDir.SetInfo
        Dim WshShell
        Set WshShell = WScript.CreateObject("WScript.Shell")
        vBaseDir.Path = WshShell.RegRead("HKLM\SOFTWARE\Microsoft\ComPlus\sdkInstallRoot") & "Samples\Setup\VirtualDirRoot"
        vBaseDir.SetInfo
        If (Err <> 0) Then
            If Not quiet Then
                Display "Utworzenie " & vRoot.ADsPath & "/" & vBaseName & " nie powiodo si."
            End If
            exit sub
        else
            Err = 0
            'display vBaseDir.name
        end if
    end if

    Dim J
    For J = 0 To UBound(vNames)

        ' Usunicie istniejcego vroot w razie potrzeby
        vBaseDir.Delete "IIsWebVirtualDir", vNames(J)
        vBaseDir.SetInfo
        Err=0 ' skasowanie bdu
    
        Set vDir = vBaseDir.Create("IIsWebVirtualDir",vNames(J))
        If (Err <> 0) Then
            If Not quiet Then
                Display "Utworzenie " & vBaseDir.ADsPath & "/" & vNames(J) & "nie powiodo si."
            End If
            exit sub
        else
            'display vdir.name
        end if

        ' Ustawienie waciwoci nowego vroot 
        vDir.AccessRead = true
        vDir.Path = vPaths(J)
        vDir.Accessflags = 529
        VDir.AppCreate False

        ' Zatwierdzenie zmian
        vDir.SetInfo
        If (Err <> 0) Then
            If Not quiet Then
                Display "Utworzenie katalogu wirtualnego IIS dla " & vBaseDir.Name & "/" & vNames(J) & "nie powiodo si."
            End If
            exit sub
        end if

        If Not quiet Then
            ' Zgoszenie sukcesu
            WScript.Echo "Katalog wirtualny http://localhost/" & vBaseDir.Name & "/" & vnames(J) & " zosta utworzony."
        End If
    Next
End Sub




'Poniszy kod pochodzi z mkwebdir.vbs i zosta zmieniony tak, aby utworzy jeden katalog vDir.
Sub DeleteVDir(vNames, vBaseName)

    Dim vRoot,vBaseDir,vDir,vTempDir,webSite,ipSecurityObj,ipList
    On Error Resume Next

    ' Uzyskanie domylnej witryny lokalnego hosta
    set webSite = GetObject("IIS://localhost/w3svc/1")
    if IsObject(webSite)=False then
        If Not quiet Then
            Display "Odnalezienie domylnej witryny nie byo moliwe. Naley zainstalowa i uruchomi IIS."
        End If
        exit sub
    else
        'display webSite.name
    end if

    ' Uzyskanie katalogu macierzystego
    set vRoot = webSite.GetObject("IIsWebVirtualDir", "Root")
    If (Err <> 0) Then
        If Not quiet Then
            Display "Nie mona uzyska dostpu do katalogu macierzystego dla " & webSite.ADsPath
        End If
        Exit sub
    else
        'display vRoot.name
    End If

    ' Odnalezienie lub utworzenie NetSDK vroot. Jest to macierzysty vroot dla wszystkich przykadw NetSDK.
    ' Fizyczna cieka do http://localhost/CLRUnleashed jest ustawiona na folder ...\Samples\Setup\VirtualDirRoot.
    Err.Number = 0 'Skasowanie bdu
    Set vBaseDir = GetObject(vRoot.ADsPath & "/" & vBaseName)

    Dim K
    For K = 0 To UBound(vNames)
        ' Usunicie istniejcego vroot w razie potrzeby
        vBaseDir.Delete "IIsWebVirtualDir", vNames(K)
        vBaseDir.SetInfo

        If Not quiet Then
            WScript.Echo "Katalog wirtualny http://localhost/" & vBaseDir.Name & "/" & vnames(K) & " zosta usunity."
        End If
    Next
End Sub


Sub Display(Msg)
    If Not quiet Then
        WScript.Echo Now & ". Kod bdu: " & Hex(Err) & " - " & Msg
    End If
End Sub

Sub Trace(Msg)
    If Not quiet Then
        WScript.Echo Now & " : " & Msg  
    End If
End Sub

Sub DeleteWeb(WebServer, WebName)
    ' Usunicie istniejcej witryny (ignorowane w razie braku takiej witryny)
    On Error Resume Next
    Dim vDir
    If Not quiet Then
        display "usuwanie " & WebName
    End If

    WebServer.Delete "IISWebVirtualDir",WebName
    WebServer.SetInfo
    If Err=0 Then
        If Not quiet Then
            DISPLAY "WEB " & WebName & " usunito."
        End If
    else
        If Not quiet Then
            display "Nie mona odnale " & webname
        End If
    End If
End Sub


